<?php
/**
 * Created by PhpStorm.
 * User: gtoma
 * Date: 2020.03.15.
 * Time: 6:57
 */

include_once APP_PATH . "classes/Model.php";

class EnuProduct extends Model {

    private $enuMeasure;
    public function getEnuMeasure($name = "") {
        if(!$this->enuMeasure) {
            $this->enuMeasure = myQuery("SELECT * FROM dbo.EnuMeasure WHERE EnuMeasureID=".$this->getDbData("ENU_MEASURE_1"));
        }
        return ($name && isset($this->enuMeasure[$name]))
            ? $this->enuMeasure[$name]
            : $this->enuMeasure;
    }

    protected $enuProductId;
    protected $helyszin;
    protected $etlapKod;
    public function setHelyszin($helyszin) {
        $this->helyszin = $helyszin;
        return $this;
    }
    public function setEtlapKod($etlapKod) {
        $this->etlapKod = $etlapKod;
        return $this;
    }

    protected function load($productId) {
        $this->enuProductId = $productId;
        $this->dbData = myQuery("SELECT EnuProduct.*, EnuProdGroup.ENU_PRODUCT_0 AS conGroupProd FROM dbo.EnuProduct LEFT JOIN dbo.EnuProdGroup ON EnuProdGroup.EnuProdGroupID = EnuProduct.ENU_PRODGROUP_1 WHERE EnuProductID=".$this->enuProductId);
        $this->getEnuMeasure();
        return $this;
    }
    
    public function getKapcsoltTermek($productId) {
        $r = myQuery("SELECT * FROM dbo.EnuProduct WHERE EnuProductID=".$productId);
        return $r;
    }
    
    public function getKapcsoltCsoport($groupId) {
        $r = myQuery("SELECT * FROM dbo.EnuProdGroupConnects WHERE EnuProdGroupID=".$groupId." AND DELETEDBY IS NULL");
        return $r;
    }

    /**
     * @return array ["afa" => (int), "afaK" => (int) ]
     */
    public function calculateAfa($asztalKepTipus = 0) {
        $afa = $this->getDbData('ValueVAT');
        $afaK =  $this->getDbData('ENU_NATIVEVAT_1');
        
        if(!empty($_POST['params']['selectedVat'])){
            $sv = intval($_POST['params']['selectedVat']);
            $afaK = $this->getDbData('ENU_NATIVEVAT_'.$sv);
            $afa = $this->getDbData('ValueVAT'.($sv==1?'':2));
            return array(
                "afa" => $afa,
                "afaK" => $afaK
            );
        }

        if (($this->getDbData('ENU_NATIVEVAT_1') == 0) && ($this->getDbData('ENU_NATIVEVAT_2') == 0)) {
            return array(
                "afa" => $afa,
                "afaK" => $afaK
            );
        }
        
        //Helyben fogyasztás
        $termekVat1 = $this->getDbData('ValueVAT');
        $termekVat2 = $this->getDbData('ValueVAT2');
        $termekVatNative1 = $this->getDbData('ENU_NATIVEVAT_1');
        $termekVatNative2 = $this->getDbData('ENU_NATIVEVAT_2');
        if($termekVatNative1 > 0 && $termekVatNative2 > 0){
            if($termekVat1 < $termekVat2){
                $afa = $termekVat1;
                $afaK = $termekVatNative1;
            } else{
                $afa = $termekVat2;
                $afaK = $termekVatNative2;
            }
        } elseif($termekVatNative1 == 0 && $termekVatNative2 > 0){
            $afa = $termekVat2;
            $afaK = $termekVatNative2;
        } elseif($termekVatNative1 > 0 && $termekVatNative2 == 0){
            $afa = $termekVat1;
            $afaK = $termekVatNative1;
        }

        /**
         * Ellenőrizzük hogy elviteles e a rendelés
         * 73 Elvitel
         * 52 Nem tudom ni az
         */
        if($asztalKepTipus == 73) {
            $bKiszallitasos = true;
        } elseif($asztalKepTipus == 52) {
            $bKiszallitasos = false;
        }
		else 
		{
			$bKiszallitasos = false;
		}
		/* else {
            return array(
                "afa" => $afa,
                "afaK" => $afaK
            );
        }*/

        //Elviteles rendelés
        if($bKiszallitasos){
            if($termekVatNative1 > 0 && $termekVatNative2 > 0){
                if($termekVat1 > $termekVat2){
                    $afa = $termekVat1;
                    $afaK = $termekVatNative1;
                } else{
                    $afa = $termekVat2;
                    $afaK = $termekVatNative2;
                }
            } elseif($termekVatNative1 == 0 && $termekVatNative2 > 0){
                $afa = $termekVat2;
                $afaK = $termekVatNative2;
            } elseif($termekVatNative1 > 0 && $termekVatNative2 == 0){
                $afa = $termekVat1;
                $afaK = $termekVatNative1;
            }
        }
        
        /*if (
            ($this->getDbData('ENU_NATIVEVAT_1') == getVATId(TAFAController::_27_ETEL) or $this->getDbData('ENU_NATIVEVAT_2') == getVATId(TAFAController::_27_ETEL))
            and
            ($this->getDbData('ENU_NATIVEVAT_1') == getVATId(TAFAController::_18_ETEL) or $this->getDbData('ENU_NATIVEVAT_2') == getVATId(TAFAController::_18_ETEL))
        ) {
            if ($bKiszallitasos) {
                $afaK = getVATId(TAFAController::_27_ETEL);
            } else {
                $afaK = getVATId(TAFAController::_18_ETEL);
            }
        } elseif (
            ($this->getDbData('ENU_NATIVEVAT_1') == getVATId(TAFAController::_27_ITAL) or $this->getDbData('ENU_NATIVEVAT_2') == getVATId(TAFAController::_27_ITAL))
            and
            ($this->getDbData('ENU_NATIVEVAT_1') == getVATId(TAFAController::_18_ITAL) or $this->getDbData('ENU_NATIVEVAT_2') == getVATId(TAFAController::_18_ITAL))
        ) {
            if ($bKiszallitasos) {
                $afaK=getVATId(TAFAController::_27_ITAL);
            } else {
                $afaK=getVATId(TAFAController::_18_ITAL);
            }
        }*/

        //$afa = getValueVATById($afaK);
        return array(
            "afa" => $afa,
            "afaK" => $afaK
        );
    }

    public function isRendelheto() {
        $data = $this->loadProdDataFromSQLFunc();
        /** DESA: NEM JÓ! 0 az is, ami esystemben rendelhető!!!! */
        return TRUE;
        /*return ($data[8] == 0) ? false : true;*/
    }
    public function getActualPriceByHelyszin() {
        $data = $this->loadProdDataFromSQLFunc();
        return $data[4];
        /*return array(
            "listaAr" => $data[4],
            "felarSzazalek" => ($data[9] == 1) ? $data[10] : 0,
        );*/
    }
    public function getBearByHelyszin() {
        $data = $this->loadProdDataFromSQLFunc();
        return $data[6];
    }
    private $prodDataInSQLFunc = null;
    private function loadProdDataFromSQLFunc() {
        if($this->prodDataInSQLFunc == null) {
            /*@tkod int
            @ear varchar(50),
            @helyszin int,
            @kerekites int,
            @maidopont varchar(30),
            @maOra varchar(20),
            @Rhelyszin int,
            @eutipus int,*/

            $ear = "PriceGRS".$this->etlapKod;
            $Rhelyszin = 1; /** DESA: Mi is az az Rhelyszíne?! */
            $SQL = "
DECLARE @adatok VARCHAR(250);
EXEC [dbo].[getTermekAdatok] ".$this->enuProductId.", '".$ear."', ".$this->helyszin.", ".KEREKITESTIZEDES.", '".date("Y-m-d H:i:s")."', '".date("H:i:s")."', ".$Rhelyszin.", 0, @adatok OUTPUT
select @adatok as adatok
";
            $q = myQuery($SQL);
            $this->prodDataInSQLFunc = explode("<#>", iconv("ISO-8859-2", "UTF-8", $q["adatok"]));

            /**
             * Válasz key >= 1
             * 1 @meekod - mennyiség egysége (8)
             * 2 @meeSZoveg - neve (kg)
             * 3 @afakod - áfa kódja? (4)
             * 4 @egysegar - enuProductCarte-ból, felszorozva a hotel felárral - ha van.
             * 5 @nev - termék név
             * 6 @bear - termék BEKERÜLÉSI ára
             * 7 @mixer - dbo.EnuProduct.isMixerType azaz hogy mixer tipus-e
             * 8 @er - hát, talán hogy rendelhető-e? alapból 1, de ha le van tiltva, akkor 0, viszont ha @feladag nem lehet, akkor 2 DESA: NEM JÓ 0-olyan temrék is, ami esystemben rendelhető!
             * 9 @felaras - Ha számolt időszakos árat, az alapárhoz akkor 1 || 0
             * 10 @fsz - A felszámolt felár százalék
             * 11 @seged - dbo.EnuProduct.isWithProduct
             * 12 @kapcsoltTkod - dbo.EnuProduct.withProductID
             */
        }

        return $this->prodDataInSQLFunc;
    }

    private $idoszakosAr = null;
    public function getIdoszakosAr() {
        if($this->idoszakosAr === null) {
            $sqlscript1="SELECT * FROM dbo.idoszakosArak WHERE termekKod=".$this->enuProductId." AND mettol<='".date("Y-m-d H:i:s")."' AND meddig>='".date("Y-m-d H:i:s")."' AND etlapKod=".$this->etlapKod.";";
            $adatokIdoszakosAr = myQuery($sqlscript1);
            if (is_array($adatokIdoszakosAr) && count($adatokIdoszakosAr) > 0) {
                $this->idoszakosAr = $adatokIdoszakosAr['ujar'];
            } else {
                $this->idoszakosAr = false;
            }
        }
        return $this->idoszakosAr;
    }

    /** ------------------------- */
    public function getTermekCsoportKedv() {
        $sqlscript2="SELECT * FROM dbo.idoszakosCsoportArak WHERE termekCsoportKod=".$this->getDbData("ENU_PRODGROUP_1")." AND mettol<='".
            date("Y-m-d H:i:s")."' AND meddig>='".date("Y-m-d H:i:s")."' AND etlapKod=".$this->etlapKod.";";
        $adatokIdoszakosArCsoport = myQuery($sqlscript2);

        if (is_array($adatokIdoszakosArCsoport) && count($adatokIdoszakosArCsoport) > 0) {
            return $adatokIdoszakosArCsoport['szazalek'];
        } else {
            return FALSE;
        }
    }
    
    public function getVat() {
        $d = array(
            'ENU_NATIVEVAT_1',
            'ENU_NATIVEVAT_2',
            'ValueVAT',
            'ValueVAT2'
        );
        $r = array();
        
        $nv = myQuery("SELECT * FROM dbo.EnuNativeVat");
        
        foreach ($d as $value) {
            $r[$value] = $this->dbData[$value];
        }
        
        foreach ($nv as $key => $value) {
            if($value['EnuNativeVatID'] == $r['ENU_NATIVEVAT_1']){
                $r['Name'] = $value['Name'];
            }
            if($value['EnuNativeVatID'] == $r['ENU_NATIVEVAT_2']){
                $r['Name2'] = $value['Name'];
            }
        }
        
        //php 5.5.x től jó ez a kód. Jelenleg 5.3.5 fut
        /*$k = array_search($r['ENU_NATIVEVAT_1'], array_column($nv, 'EnuNativeVatID'));
        $r['Name'] = $nv[$k]['Name'];
        
        $k = array_search($r['ENU_NATIVEVAT_2'], array_column($nv, 'EnuNativeVatID'));
        if($k !== false){
            $r['Name2'] = $nv[$k]['Name'];
        }*/
        
        return $r;
    }

}