<?php
/**
 * Created by PhpStorm.
 * User: gtoma
 * Date: 2020.03.14.
 * Time: 5:36
 */

include_once APP_PATH . "classes/Model.php";
include_once APP_PATH . "classes/EnuProduct.php";

class JobOrderItems extends Model {
    private static $halfValue;
    public static function getHalfValue() {
        if(!JobOrderItems::$halfValue) {
            $feladag_erteke = myQuery("SELECT description FROM sysTypeDef WHERE sysTypeDefId=100000");
            JobOrderItems::$halfValue = $feladag_erteke['description'];
        }
        return JobOrderItems::$halfValue;
    }

    /**
     * @param $orderId
     * @return array|JobOrderItems
     */
    public static function loadByOrderId($orderId) {
        if(!is_numeric($orderId)) { return array(); }
        $SQL = "SELECT * FROM dbo.JobOrderItems WHERE JobOrderID=".$orderId;
        $list = myQuery($SQL);
        $resp = array();
        if(is_array($list) && !empty($list)) {
            if(isset($list["JobOrderID"])) {
                $new = JobOrderItems::createClass($list);
                $resp[] = $new;
            } else {
                $resp = array();
                foreach ($list as $item) {
                    $new = JobOrderItems::createClass($item);
                    $resp[] = $new;
                }
            }
        }
        return $resp;
    }


    /**
     * @var EnuProduct
     */
    private $enuProductData;
    public function getEnuProductData() {
        if(!$this->enuProductData) {
            $this->enuProductData = EnuProduct::getById($this->getDbData("ENU_PRODUCT_1"));
        }
        return $this->enuProductData;
    }


    public function getMenuTypeString() {
        $menutipSZ = "";
        switch($this->getDbData('menuType')) {
            case 400020: $menutipSZ = ""; break;
            case 400021: $menutipSZ = lang('PRE_MENU'); break;
            case 400022: $menutipSZ = lang('SOUP'); break;
            case 400023: $menutipSZ = lang('MAIN_MENU'); break;
            case 400024: $menutipSZ = lang('DESSERT'); break;
        }
        return $menutipSZ;
    }

    public function getCommentString() {
        return $this->getMenuTypeString()." ".$comment = iconv('ISO-8859-2', 'UTF-8', $this->getDbData("Modifier"));
    }

    public function getGrossPrice() {
        return $this->getDbData("Quantity") * $this->getDbData("PriceUSE");
    }
    public function getGrossPriceGRS() {
        return $this->getDbData("Quantity") * $this->getDbData("PriceGRS");
    }

    public function getMeasureText() {
        $resp = lang('WHOLE');
        if( $this->getDbData("isHalf") && !$this->getEnuProductData()->getDbData("isMixerType") ) {
            $resp = JobOrderItems::getHalfValue()."%";
        }
        if ($this->getEnuProductData()->getEnuMeasure('Abridgement') != 'a') {
            $resp = iconv('ISO-8859-1', 'UTF-8', trim($this->getEnuProductData()->getEnuMeasure('Abridgement')));
        }
        return $resp;
    }
}