<?php
/* Exit if accessed directly */
	if ( !defined('APP_PATH') ) die("This file cannot be accessed directly.");
	
function myEscape($data) {
    if(is_numeric($data))
        return $data;
    $unpacked = unpack('H*hex', $data);
    return '0x' . $unpacked['hex'];
}
	
/**
 * LEK�RDEZ�SHEZ HASZN�LT F�GGV�NY
 */ 
function myQuery($query, $params=array(), $nullval=true)
{
	global $db;
	
	$stmt = sqlsrv_query($db, $query, $params);
	
	if (!$stmt) {
		echo "ERROR: <br>";
		echo $query . "<br><br>";
		if( ($errors = sqlsrv_errors() ) != null) {
			foreach( $errors as $error ) {
				echo "SQLSTATE: ".$error[ 'SQLSTATE']."<br />";
				echo "code: ".$error[ 'code']."<br />";
				echo "message: ".$error[ 'message']."<br />";
			}
		}
		die();
	}
	
	if (preg_match('#select#', strtolower($query)))
	{
		$return = array();
		while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC))
		    $return[] = $row;
	}	
	else
	$return = (bool)$stmt;
	
	if ($stmt)
	{
		if (is_array($return) && !empty($return) )
			return (count($return)>1) ? $return : (!$nullval ? $return : $return[0]);
		else
			return $return;			
	}
	else 
	return false;
}

/**
 * NYELVESITETT ADATOK MEGJELENIT�S�HEZ HASZN�LT F�GGV�NY
 */ 
function lang($expression) {
	$lang_array = parse_ini_file("lang_" . LANG . ".ini");
	if(isset($lang_array[$expression])) {
		return $lang_array[$expression];
	}
	else {
		return $expression;
	}
}


function clearText($text) {
    return preg_replace("/[^a-zA-Z0-9ÀÁÂÃÄÅàáâãäåÒÓÔÕŐÖØòóôõőöøÈÉÊËèéêëÇçÌÍÎÏìíîïÙÚÛÜŰùúûüűŸÿÑñ ]/", '', $text);
}
/**
 * HIBAKERES�ST SEG�T� F�GGV�NY
 */ 
function dump($be, $text = '',  $out = true ) 
{ 
	echo '<pre>'; 
		echo $text . ": <br>";
		if ( $out ) {
			print_r($be);
		} else {
			var_dump($be); 
		}		
	echo '</pre>'; 
}

function redirect($url) {
	header('location:' . $url);
}

function getBasketSettingsAfterSum($jobID) {
    $settings = array(
        "kedv" => 0,
        "tetel" => 0,
        "szerviz" => 0
    );
    if(!is_numeric($jobID)) {
        return $settings;
    }
    $items = myQuery("SELECT allapot FROM dbo.asztalElrendezes WHERE rendelesKod=".$jobID.";");
    //var_dump($jobID);
    $closed = (isset($items["allapot"]) && $items["allapot"] == "40103")
        ? true
        : false;

    /**
     * DESC: Ha zárva, és zárás után nem adható akkor 0 egyébként 1
     * @var $settings
     */
    $settings = array(
        "kedv" => ($closed && !OSSZUTANKEDV) ? 0 : 1,
        "tetel" => ($closed && !OSSZUTANTETEL) ? 0 : 1,
        "szerviz" => ($closed && !OSSZUTANSZERVIZ) ? 0 : 1
    );
    return $settings;
}