<?php
/**
 * Created by PhpStorm.
 * User: gtoma
 * Date: 2020.03.14.
 * Time: 5:21
 */
include_once APP_PATH . "classes/Model.php";
include_once APP_PATH . "classes/JobOrderItems.php";
include_once APP_PATH . "classes/Table.php";

class JobOrder extends Model {
    
    /**
     * Vendégek számának megadása kötelező e<br>
     * JobOrder első példányosításakor adatbázisból ellenőrzi hogy meg kell e adni e vagy sem.<br>
     * Alapértelmezetten false azaz nem kötelező megadni.
     * @var boolean
     */
    private $vendegszamMegadas = false;
    
    /**
     * SysSystem.SysSystemID -t kell megadni. Alapértelmezetten 1 de változtatható ha esetleg eltér.
     * @var int
     */
    private $systemId = 1;
    
    public function __construct() {
        //$B = myQuery("SELECT * FROM dbo.SysSystem WHERE SysSystemID = " . $this->systemId);
        $B = myQuery("SELECT * FROM dbo.setup WHERE setupID = " . $this->systemId);
        $this->vendegszamMegadas = $B['VendegszamRogz'];
    }

    public static function getById($jobId) {
        $r = new JobOrder();
        $r->load($jobId);
        return $r;
    }

    private $jobOrderId;
    protected function load($jobID) {
        $this->jobOrderId = $jobID;
        $this->dbData = myQuery("SELECT * FROM dbo.JobOrder WHERE jobOrderID=".$jobID);
        return $this;
    }

    /**
     * @var JobOrderItems[]
     */
    private $JobOrderItems;
    public function getJobOrderItems() {
        if(!$this->JobOrderItems) {
            $this->JobOrderItems =  JobOrderItems::loadByOrderId($this->jobOrderId);
        }
        return $this->JobOrderItems;
    }
    public function checkAllJobOrderItemsWithChild() {
        $SQL = "select JobOrderItems.jobOrdeItemsID from JobOrderItems inner join JobOrder ON JobOrderItems.JobOrderID = JobOrder.JobOrderID"
            ." where JobOrder.JobOrderID = ".$this->jobOrderId." or JobOrder.originalJobOrderID = ".$this->jobOrderId;

        $list = myQuery($SQL);
        return (is_array($list) && !empty($list))
            ? true
            : false;
    }


    public function calculatePriceGRS() {
        $resp = 0;
        foreach ($this->getJobOrderItems() as $item) {
            if( $item->getDbData("DELETEDON") == false) {
                $resp += $item->getGrossPriceGRS();
            }
        }
        return $resp;
    }

    public function calculatePrice() {
        $resp = 0;
        foreach ($this->getJobOrderItems() as $item) {
            if( $item->getDbData("DELETEDON") == false) {
                $resp += $item->getGrossPrice();
            }
        }
        return $resp;
    }

    public function calculateServiceFee() {
        $resp=0;
        if( $this->getDbData('ValueSVC') != 0 && !$this->getTable()->isSzemelyzetOrRepi() ) {
            $resp=round($this->calculatePrice()*(($this->getDbData("ValueSVC"))/100), 2);
        }
        return $resp;
    }

    public function calculateDiscount() {
        return round($this->calculatePriceGRS()-$this->calculatePrice(), 2);
    }

    public function calculatePriceSum() {
        $osszesar = round($this->calculatePriceGRS() + $this->calculateServiceFee() - $this->calculateDiscount() - $this->getTableLimit(), 2);
        if ($osszesar < 0) { $osszesar=0; }
        if ($this->getTable()->getAsztalTipus() == 20309) { $osszesar=0; }
        return $osszesar;
    }

    /**
     * @var Table
     */
    private $Table;
    public function setTable(Table $table) {
        $this->Table = $table; return $this;
    }
    public function getTable() {
        if(!$this->Table) {
            if(
                is_numeric($this->getDbData("MAP_TABLE_1"))
            ) {
                $this->Table = Table::getById($this->getDbData("MAP_TABLE_1"));
            } else {
                $this->Table = FALSE;
            }
        }
        return $this->Table;
    }
    public function getTableLimit() {
        $resp = 0;
        return $this->Table->getDbData("limit");
    }

    public function lockOrderItems() {
        $tetelekszama = myQuery("SELECT * FROM dbo.JobOrderItems WHERE JobOrderID='".$this->jobOrderId."';");
        $reszszamlak = myQuery("SELECT * FROM dbo.JobOrder WHERE originalJobOrderID='".$this->jobOrderId."';");
        $tableType = $this->getTable()->getDbData("tipus");

        if ((count($tetelekszama) === 0) && (count($reszszamlak ) === 0)) {
            $this->unlockEmptyJobOrder();
        } else {
            $jobprint = myQuery("INSERT INTO dbo.nyomtatasok 
	  			   (jobOrderID,asztalKod,felhasznaloKod,tipus,rogzites) 
				   VALUES
				   (".$this->jobOrderId.", ".$this->getTable()->getDbData("asztalKod").", ".$_SESSION['userID'].", 1, '".date('Y-m-d H:i:s').".000');");
            if (!$jobprint) {
                echo '<b style="color:red">'.lang('ERROR_NO1').'</b><br />'.
                        '<a href="'.URL.'tables">'.lang('BACK_TO_LIST').'</a>';
                echo '<hr>';
            }
        }

        myQuery("DELETE FROM dbo.sysjobOrderOpens WHERE JobOrderID=".$this->jobOrderId);

        if ($jobprint) {
            header("Location:" . URL . "tables");
            exit();
        }
    }

    /**
     * 20.06.08. EZT MEGSZÜNTETJÜK, mert sql timer csinálja.
     * @return $this
     */
    public function unlockEmptyJobOrder() {
        /*$check = $this->checkAllJobOrderItemsWithChild();
        if($check === FALSE) {
            $Table = $this->getTable();
            if($Table !== FALSE) {
                $tableType = $this->getTable()->getDbData('tipus');
                if($tableType == 6) {
                    myQuery('update dbo.asztalElrendezes set allapot = 40104 where rendeleskod = '.$this->jobOrderId);
                } else {
                    myQuery("DELETE FROM JobOrder WHERE jobOrderID='".$this->jobOrderId."';");
                    myQuery('update dbo.asztalElrendezes set allapot = 40101 where rendeleskod = '.$this->jobOrderId);
                }
            }
        }*/
        return $this;
    }
    
    /**
     * Vendégek számát menti el
     */
    public function saveValueSeat() {
        if($this->vendegszamMegadas && empty($_GET['reszszamla'])){
            $v = intval($_GET['vendeg']);
            $B = myQuery("SELECT ValueSeat FROM dbo.JobOrder WHERE dbo.JobOrder.jobOrderID = {$this->jobOrderId};");
            if($v==0 && $B['ValueSeat']==0){
                die('A vendégszám nem megfeleő!');
            }
            if($v>0){
                $params = array(
                    $v,
                    $this->jobOrderId
                );
                myQuery("UPDATE dbo.JobOrder SET ValueSeat = ? WHERE dbo.JobOrder.jobOrderID = ?;", $params);
            }
        }
    }
    
    public function getVendegszamMegadas() {
        return $this->vendegszamMegadas;
    }
    
    public function setLastSeen() {
        myQuery("UPDATE dbo.sysJobOrderOpens SET lastSeen = GETDATE() WHERE jobOrderID = {$this->jobOrderId};");
    }

}