<?php
/**
 * Created by PhpStorm.
 * User: gtoma
 * Date: 2020.03.14.
 * Time: 5:28
 */

/**
 * 05.09 2óra
 * TODO: a dollár fizetési mód már létezik, ugyanakkor hiányzik a
 * TODO: addPayment funkció által használt "insertFizetesTemp"
 * Class Payment
 */


class Payment {
    private static $hufCashCode = 31602;
    public static function getHufCashCode() { return Payment::$hufCashCode; }
    public function filterCashPrice($price) {
        if ( !$this->isHufCash() ){
            return true;
        }
        return ( $this->roundForHufCash($price) != $price )
            ? false
            : true;
    }
    public function isHufCash() {
        return ($this->paymentTypeId === Payment::$hufCashCode);
    }
    public function getRoundPrecision($currency = "") {
        if(!$currency) { $currency = $this->getCurrency(); }
        return ($currency == "HUF" && KEREKITES)
            ? (int) KEREKITESTIZEDES
            : 2;
    }
    public function roundForHufCash($amount) {
        if(!$this->isHufCash()) {
            return $amount;
        }
        return round($amount/5, 0) * 5;
    }

    /**
     * TODO: IDe be kell rakni a DOLLÁRT IS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     * @return string HUF||EUR||USD
     */
    public function getCurrency() {
        if(!$this->paymentTypeId) { return $this->defCurrency; }
        return ($this->pdaFizMod["eur"] == 1)
            ? "EUR"
            : "HUF";
    }


    private $defRound;
    private $defRoundPrecision;
    private $defCurrency;
    private $station;
    public function __construct() {
        $this->defRound=KEREKITES;
        $this->defRoundPrecision=KEREKITESTIZEDES;
        $this->defCurrency=ALAPERTELMEZETTPENZNEM;
        $this->station = $_SESSION['station'];
    }

    /**
     * @var JobOrder
     */
    private $JobOrder;
    private $jobOrderId;

    /**
     * @var Table
     */
    private $Table;
    private $tableId;
    public static function get(JobOrder $jobOrder) {
        $r = new Payment();
        $r->JobOrder = $jobOrder;
        $r->jobOrderId = $jobOrder->getDbData("jobOrderID");
        $table = $r->getJobOrder()->getTable();
        $r->Table = $table;
        if($table !== FALSE) {
            $r->tableId = $table->getDbData("asztalKod");
        }
        return $r;
    }
    public function getTable() {
        return $this->Table;
    }

    public function getJobOrder() {
        return $this->JobOrder;
    }

    /** DESC: Ha már nyomtatás van, akkor fizetett. */
    public function checkStatusIsPrint() {
        $jobprint2 = myQuery("select count(*) c from dbo.nyomtatasok  where tipus = 3 and jobOrderId = ".$this->jobOrderId);
        return ($jobprint2['c']>0)
            ? true : false;
    }

    public function havePartInvoice() {
        $elsoReszCheck = myQuery("SELECT min(jobOrderID) as jobID FROM dbo.JobOrder WHERE originalJobOrderID=".$this->jobOrderId.";");
        return (isset($elsoReszCheck) && is_array($elsoReszCheck) && $elsoReszCheck['jobID']>0)
            ? true : false;
    }

    /**
     * DESC: Ha rész számla, akkor megnézi van-e még tétel a fő jobOrder-ben, ha nincs akkor azt zárja.
     */
    public function checkOriginalInvoiceEmpty() {
        if( ($oJobOrderId = $this->getJobOrder()->getDbData("originalJobOrderID")) && is_numeric($oJobOrderId)) {
            $oJobOrder = JobOrder::getById($oJobOrderId);
            $oJobOrder->unlockEmptyJobOrder();
            $oPayment = Payment::get($oJobOrder);
            $s = $oPayment->getJobOrder()->getJobOrderItems();

            if(
                !is_array($s) || empty($s)
            ) {
                $this->getJobOrder()->unlockEmptyJobOrder();
                return TRUE;
            } else {
                return FALSE;
            }
        }
        return TRUE;
    }

    /**
     * TODO: ez egy temp törlés, ugyanakkor NEM TÖRLÖM akkor ha a fizetést lezárom.
     * TODO: befutok ide akkor is, ha fizettem.
     * TODO: A baj az az, hogy az asztal lezárása
     */
    public function clearTemp() {
        $kezdodik_query = "USE [".SZERVERADATBAZIS."] EXEC [dbo].[deleteFizetesTempRendeles] ".$this->jobOrderId.";";
        myQuery($kezdodik_query);

        myQuery("INSERT INTO dbo.nyomtatasok 
	  			   (jobOrderID,asztalKod,felhasznaloKod,tipus,rogzites) 
				   VALUES
				   (".$this->jobOrderId.", ".$this->tableId.", ".$_SESSION['userID'].", 1, '".date('Y-m-d H:i:s').".000');");

        $jobOrder = myQuery("SELECT SYS_TYPEDEF_1 FROM dbo.JobOrder WHERE jobOrderID=".$this->jobOrderId);
        $status = $jobOrder['SYS_TYPEDEF_1'];
        if ($status!=40103) {
            //var_dump($this->jobOrderId, "b");
            myQuery("UPDATE dbo.JobOrder SET SYS_TYPEDEF_1=40103 WHERE jobOrderID=".$this->jobOrderId);
            $c = $this->checkOriginalInvoiceEmpty();
            if( $c ) {
                myQuery("UPDATE dbo.asztalElrendezes SET allapot=40103 WHERE asztalKod=".$this->tableId);
            }
            myQuery("INSERT INTO dbo.nyomtatasok 
	  			   (jobOrderID,asztalKod,felhasznaloKod,tipus,rogzites) 
				   VALUES
				   (".$this->jobOrderId.", ".$this->tableId.", ".$_SESSION['userID'].", 2, '".date('Y-m-d H:i:s').".000');");
        }
    }

    private $paymentTypeId;
    private $pdaFizMod; //SQL
    public function setPaymentTypeId($pId) {
        $this->paymentTypeId = $pId;
        $this->pdaFizMod = myQuery("select * from dbo.PdaFizMod where SysTypedefID=".$this->paymentTypeId);
        return $this;
    }

    /**
     * DESC: az összeget rakja be az insertFizetesTemp-be.
     * @param $osszeg float !!!!!!! FORINTBAN MENTÜNK!
     */
    public function addPayment($osszeg) {
        $tetelAdd_query = "USE [".SZERVERADATBAZIS."] EXEC [dbo].[insertFizetesTemp] ".$this->jobOrderId.", ".$this->paymentTypeId.", ".
            round( $osszeg,  $this->getRoundPrecision() )
            .", 1;";
        myQuery($tetelAdd_query);
    }

    public function deletePayment($tempId) {
        $teteltorol_query = "USE [".SZERVERADATBAZIS."] EXEC [dbo].[deleteFizetesTemp] ".$tempId.";";
        myQuery($teteltorol_query);
    }

    /**
     * TODO: miért van 2 ugyan olyan sor?! elsőre beteszi a nyomtatasok -ba 1-es tipussal, és rögtön utána egy 3-as tipussal?! azaz 2 sort hoz létre. Gergő: Az Etterem.exe figyeli ezt a táblát, az 1-es összesítőt nyomtat, a 3-as lefizetteti az asztalt
     * TODO: Mit csinál a sysjobORderOpens? Gergő: az tárolja, milyen rendelések melyik gépen vannak nyitva. Meggátolja, hogy más gépek hozzányúljanak.
     */
    public function closePayment() {
        myQuery("INSERT INTO dbo.nyomtatasok  (jobOrderID,asztalKod,felhasznaloKod,tipus,rogzites) 
					   VALUES (".$this->jobOrderId.", ".$this->tableId.", ".$_SESSION['userID'].", 1, '".date('Y-m-d H:i:s').".000');");

        myQuery("INSERT INTO dbo.nyomtatasok  (jobOrderID,asztalKod,felhasznaloKod,tipus,rogzites) 
					   VALUES (".$this->jobOrderId.", ".$this->tableId.", ".$_SESSION['userID'].", 3, '".date('Y-m-d H:i:s').".000');");

        myQuery("INSERT INTO dbo.sysjobOrderOpens  (jobOrderID,computerName,isPDAPay) 
					   VALUES (".$this->jobOrderId.", '".$_SESSION['computer']."', 1);");
    }

    private $exchangeRate;
    public function getExchangeRate($currency = "") {
        if(!$currency) { $currency = $this->getCurrency(); }
        if(!$this->exchangeRate) {
            $this->exchangeRate = array(
                "HUF" => 1,
                "EUR" => 1,
                "USD" => 1
            );
            $arf = 0;
            $arfCheck = myQuery("SELECT * FROM dbo.sysStation WHERE sysStationID=".$this->station.";");
            if (isset($arfCheck) && is_array($arfCheck) && $arfCheck['sysStationID']>0) {
                $this->exchangeRate["EUR"] = $arfCheck['CurrencyMUL'];
                $this->exchangeRate["USD"] = $arfCheck["USDCurrencyMUL"];
            }
        }
        return $this->exchangeRate[$currency];
    }

    private $payedItems;
    public function getPayedItems() {
        if(!$this->payedItems) {
            $jobFizSQL = "SELECT dbo.fizetesTemp.*, dbo.SysTypedef.Description
				  FROM dbo.fizetesTemp LEFT OUTER JOIN  dbo.SysTypedef ON dbo.fizetesTemp.fizmodkod = dbo.SysTypedef.SysTypedefID 
				  WHERE rendelesKod=".$this->jobOrderId.";";
            $dbjobitems = myQuery($jobFizSQL, null, false);
            $this->payedItems = (is_array($dbjobitems))
                ? $dbjobitems
                : array();
        }
        return $this->payedItems;
    }

    /**
     * Le kell csekkolnunk, hogy ha zárja a fizetést, és volt benne kp-s fizetés, akkor minkdenképp
     * kell a kp-s kerekítás.
     */
    public function checkPayedWithHufCache() {
        foreach ($this->getPayedItems() as $item) {
            if($item["fizmodkod"] == Payment::$hufCashCode) {
                return TRUE;
            }
        }
        return FALSE;
    }
}