<?php

/* Exit if accessed directly */
if (!defined('APP_PATH'))
    die("This file cannot be accessed directly.");

function getTableListHTML($helyszin) {
    $db = getDB();
    /**
     * Lekéri az összes olyan helyet, ahol VAN ASZTAL!
     */
    $tables = myQuery("SELECT EnuPlace.enuPlaceID, EnuPlace.Name, EnuPlace.kiszallitas, EnuPlace.etlapkod, asztalElrendezes.asztalKod,
						  asztalElrendezes.allapot, asztalElrendezes.openingTime, asztalElrendezes.vevo, asztalElrendezes.rendelesKod, asztalElrendezes.rendelesSzekenkent, 
						  asztalElrendezes.asztalElrendezesKod, asztalok.asztalID, asztalok.asztal, asztalok.kedv, asztalok.limit, asztalok.tipus, asztalok.mag, asztalok.szel, 
						  asztalok.nev, asztalok.azonosito, asztalElrendezes.xk, asztalElrendezes.yk, EnuPlace.sysStationID,
						  j.ValueDSC, j.ValueSVC, j.isReady, j.ENU_LANGUAGE_1
					FROM dbo.asztalElrendezes 
					LEFT JOIN dbo.asztalok ON asztalElrendezes.asztalKod = asztalok.asztalKod 
					LEFT JOIN dbo.EnuPlace ON asztalElrendezes.enuPlaceId = EnuPlace.enuPlaceID
					LEFT JOIN dbo.SysStation ON SysStation.sysStationID = EnuPlace.sysStationID
					LEFT JOIN dbo.JobOrder j ON asztalElrendezes.rendelesKod = j.jobOrderID
					WHERE (asztalElrendezes.zarolva = 0) AND (asztalok.torolve = 0) AND (SysStation.isHotelType = 0)
" . //					  and EnuPlace.enuPlaceID in (". implode(",", $ENGEDELYEZETTHELY).")
        "and EnuPlace.enuPlaceID = " . $helyszin . "				  
					ORDER BY asztalok.rendezes, asztalok.nev asc;", array(), false);

    //dump($tables, 'tables', false);

    $places = array();
    $stations = array();
    $placeCodes = array();
    //$tbl_html = '<div style="border:1px solid transparent; width:{MAXWIDTH}; height:{MAXHEIGHT}">';
    //$tbl_num = 0;
    $maxw = 0;
    $maxh = 0;
    $tables_list = '';

    foreach ($tables as $tbl) {
        //dump($tbl, 'tbl', false);

        $asztalkodxx = $tbl['asztalKod'];

        $rendCheck = sqlsrv_query($db, "SELECT max(jobOrderId) AS maxkod FROM dbo.jobOrder WHERE MAP_TABLE_1=" . $asztalkodxx . ";", array());
        $rendCheck_result = sqlsrv_fetch_array($rendCheck, SQLSRV_FETCH_ASSOC);
        $maxRendKod = $rendCheck_result['maxkod'];

        //$allapotCheck = sqlsrv_query($db, "SELECT SYS_TYPEDEF_1 AS allapot FROM dbo.jobOrder WHERE jobOrderID=".$maxRendKod.";", array());
        $allapotCheck = sqlsrv_query($db, "SELECT allapot FROM dbo.asztalElrendezes WHERE asztalKod=" . $asztalkodxx . ";", array());
        if ($allapotCheck) {
            $allapotCheck_result = sqlsrv_fetch_array($allapotCheck, SQLSRV_FETCH_ASSOC);
            $allapotxx = $allapotCheck_result['allapot'];
        } else {
            $allapotxx = false;
        }

        if (!in_array($tbl['enuPlaceID'], $places))
            if ($tbl['kiszallitas'] != 1) {
                $places[$tbl['enuPlaceID']] = iconv("ISO-8859-1", "UTF-8", $tbl['Name']);
                $stations[$tbl['enuPlaceID']] = $tbl['sysStationID'];
                $placeCodes[$tbl['enuPlaceID']] = $tbl['etlapkod'];
            }

        //if ($tbl['enuPlaceID'] == $helyszin) 
        //{
        //if ($tbl['rendelesSzekenkent']!=0)
//				$tbl_num++;

        if ($tbl['yk'] > $maxh)
            $maxh = $tbl['yk'] + 100;

        if ($tbl['xk'] > $maxw)
            $maxw = $tbl['xk'] + 100;

        if ($tbl['asztal'] == 1) {
            $bgszin = 'green';
            $fontszin = 'white';
            $class = "green";
        } else {
            $bgszin = 'yellow';
            $fontszin = 'black';
            $class = "yellow";
        }

        if ($allapotxx == 40104) {
            $bgszin = 'yellow';
            $fontszin = 'black';
            $class = "yellow";
        }

        if ($allapotxx == 40103) {
            $bgszin = 'red';
            $fontszin = 'white';
            $class = "red";
        }

        if ($allapotxx == 40102) {
            $bgszin = 'blue';
            $fontszin = 'white';
            $class = "blue";
        }
        $ready = '';
        if (!empty($tbl['isReady'])) {
            //$class .= " isReady";
            $ready = '<img src="images/icon_sef.svg" alt="" class="icon">';
        }

        /*
         * Ha megvan nyitva akkor felülír minden színt majd ha 2 perc eltelik újra alapértelmezett színű
         */

        $B =array();
        if ( $tbl['rendelesKod']!=0)
        {
			$B = myQuery("SELECT (CASE WHEN (DATEDIFF(n, lastSeen, GETDATE()) >= 2 OR lastSeen IS NULL) THEN 0 ELSE 1 END) AS isOpen, computerName "
				. "FROM dbo.sysJobOrderOpens "
				. "WHERE jobOrderID = $tbl[rendelesKod]");
        }		 
		
        if (isset($B['isOpen']) && ($B['isOpen']==1))
		{
            $bgszin = 'purple';
            $fontszin = 'white';
            $class = "purple";
        }

        $modnev = iconv("ISO-8859-2", "UTF-8", $tbl['azonosito']);
        $html = '<a href="table_orders.php" 
						 class="place_block" 
						 style="width:' . ($tbl['szel'] - 2) . 'px; height:' . ($tbl['mag'] - 10) . 'px; margin: ' . ($tbl['yk'] + 20) . 'px 0 0 ' . ($tbl['xk']) . 'px; background-color: ' . $bgszin . '; color: ' . $fontszin . '">
						' . trim($modnev) .
            '</a>';

        $isOrderOneCliensUsedSql = myQuery('SELECT isOrderOneCliensUsed FROM setup WHERE setupID=1;');
        $isOrderOneCliensUsed = $isOrderOneCliensUsedSql['isOrderOneCliensUsed'];

        if (empty($B['computerName']) || ($isOrderOneCliensUsed && $B['computerName'] == $_SESSION['computer']) || !$isOrderOneCliensUsed) {
            $atl = '<a href="' . URL . 'table/' . $tbl['asztalKod'] . '" class="' . $class . '">' . $ready . trim($modnev) . '</a>';
        } else {
            $atl = '<span class="darkblue">' . $ready . trim($modnev) . '</span>';
        }

        //$html = str_replace('B64ENCODED', base64_encode($html), $html);
        //$tbl_html .= $html;
        $tables_list .= $atl;
        //}
    }
    return $tables_list;
}

function getChafingSign($helyek){
    $w = '';
    $playSound = false;
    $sign = array();
    foreach ($helyek as $value) {
        $w .= (!empty($w)?' OR ':'').'enuPlaceId='.$value;
        $sign[$value] = 0;
    }
    if(!empty($w)){
        $w = " AND ($w)";
    }
    $Betoltes = myQuery("SELECT JobOrder.jobOrderID, jobOrdeItemsID, enuPlaceId "
        . "FROM dbo.JobOrder "
        . "LEFT JOIN dbo.JobOrderItems ON JobOrder.jobOrderID = JobOrderItems.JobOrderID AND JobOrderItems.ReadyBy IS NOT NULL "
        . "WHERE isReady=1".$w, array(), false);
    if(!empty($Betoltes) && count($Betoltes)>0){
        foreach ($Betoltes as $B) {
            $sign[$B['enuPlaceId']] = 1;
            if(PLAYSOUNDONCE){
                if(empty($_SESSION['ps'][$B['jobOrderID']][$B['jobOrdeItemsID']])){
                    $_SESSION['ps'][$B['jobOrderID']][$B['jobOrdeItemsID']] = 1;
                    $playSound = true;
                }
            } else{
                $playSound = true;
            }
        }
    }
    $i = 0;
    $place = '';
    foreach ($sign as $key => $value) {
        $place .= "place[$i]=[$key,$value];";
        $i++;
    }
    $signPlaces = '<script>var place=[];'.$place.'placeSign(place);</script>';
    return array(
        'playSound' => $playSound?'<script>playSound(\'jelzes.wav\');</script>':'',
        'sign' => $signPlaces
    );
}